define(['app', 'angular'], function (app, angular) {

	app.directive('inputGroupCheckbox', function () {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'name': '@',
				'ngDisabled': '=',
				'ngRequired': '=',
				'ngModel': '='
			},
			link: function(scope, elems, attrs, ngModelCtrl) {
				var hasNone = false;
				var modelLength = scope.ngModel.length;
				if (scope.ngModel[scope.ngModel.length - 1]) {
					hasNone = true;
				}

				if(scope.ngRequired) {
	                var validator = function(newVal) {
	                	var selectionMade = false;

	                	selectionMade = newVal.some(function(val){
	                		return val.selected;
	                	});

                		ngModelCtrl.$setValidity("selectionMade", selectionMade);
	                	return newVal;
	                };

	                ngModelCtrl.$parsers.push(validator);
	                ngModelCtrl.$formatters.push(validator);
				}


				scope.onChange = function (changedModel) {
					if (scope.ngModel[modelLength - 1].type === "NONE" && scope.ngModel[modelLength - 1].selected || changedModel.type === "NONE") {
						var pressedValState = changedModel.selected;

						scope.ngModel.forEach(function (model) {
							model.selected = false;
						});
						changedModel.selected = pressedValState;
					}
					if(scope.ngRequired) {
						validator(scope.ngModel);
					}
				};

			},
			templateUrl: 'src/ui-components/form/controls/simple/input-group-checkbox/input-group-checkbox_template.html'
		};
	});

});